//
//  BIPObject+ExportAdditions.h
//  BISubstrate
//
//  Created by Peter Norris on 2014-04-22.
//
//

#import <Foundation/Foundation.h>

#import "BIPObject.h"

#import <MCFoundation/MCFoundationDefines.h>

@interface BIPObject (ExportAdditions)

#pragma mark CSV Exporting
+ (NSString *)BPCommaDelimitedRepresentationOfObject:(id)exportObj usingFieldDicts:(NSArray *)fieldDicts;
+ (BOOL)BPCreateCommaDelimitedFileWithFilename:(NSString *)aFilename
                                   fromObjects:(NSArray *)objs
                         withExportFieldsDicts:(NSArray *)fieldDicts
                                      encoding:(NSStringEncoding)encoding
                                lineEndingType:(MCLineEndingType)lineEndingType;
- (NSString*)BPCommaDelimitedRepresentation:(NSArray*)fieldDicts;

+ (NSString *)BPTabDelimitedRepresentationOfObject:(id)exportObj usingFieldDicts:(NSArray *)fieldDicts;
+ (BOOL)BPCreateTabDelimitedFileWithFilename:(NSString*)aFilename
                                 fromObjects:(NSArray*)objs
                       withExportFieldsDicts:(NSArray*)fieldDicts;
+ (BOOL)BPCreateTabDelimitedFileWithFilename:(NSString *)aFilename
                                   fromObjects:(NSArray *)objs
                         withExportFieldsDicts:(NSArray *)fieldDicts
                                      encoding:(NSStringEncoding)encoding
                                lineEndingType:(MCLineEndingType)lineEndingType;
- (NSString*)BPTabDelimitedRepresentation:(NSArray*)fieldDicts;

@end
